<?php defined('BASEPATH') OR exit('No direct script access allowed');

class Exam_Configuration extends CI_Controller{
    public function __construct() {
        parent::__construct();
        
        $this->data['page_name'] = "Exam Configuration";
        /**
         * Loading Models
         */
        $this->load->model('exam_configuration_model','ec_model');
        $this->load->model('exam_standard_model','es_model');
        $this->load->model('exam_org_model','eo_model');
        $this->load->model('post_level_model','pl_model');
        $this->load->model('subject_model');

        $this->data['exam_standards'] = $this->es_model->get();
        $this->data['exam_organisations'] = $this->eo_model->get(); 
        $this->data['post_levels'] = $this->pl_model->get();      
        $this->data['subjects'] = $this->subject_model->get();
    }
    
    public function index(){        
        $this->data['exam_configurations'] = $this->ec_model->get();
        $this->load->view('exam_configuration/index',$this->data);
    }
    
    public function create(){
        $this->form_validation->set_rules(array(
            array(
                'field' => 'exam_duration',
                'label' => 'Time Duration',
                'rules' => 'required|numeric',
                'errors' => array(
                        'required' => 'Please provide a %s for the Exam.',
                        'numeric' => 'Exam %s can only be numeric.'
                )
            ),
            array(
                'field' => 'nos_ques',
                'label' => 'Total no. of Questions',
                'rules' => 'required',
                'errors' => array(
                        'required' => 'Please provide %s for this Exam.',
                )
            ),
            array(
                'field' => 'exam_standard_ID',
                'label' => 'Exam Standard',
                'rules' => 'required',
                'errors' => array(
                        'required' => 'Please select an %s.',
                )
            ),
            array(
                'field' => 'exam_org_ID',
                'label' => 'Exam Organisation',
                'rules' => 'required',
                'errors' => array(
                        'required' => 'Please select an %s.',
                )
            ),
            array(
                'field' => 'post_level_ID',
                'label' => 'Post Level',
                'rules' => 'required',
                'errors' => array(
                        'required' => 'Please select a %s.',
                )
            )
       ));
        if($this->form_validation->run() === true){
            if($this->ec_model->insert()){
                set_alert('success' ,'New Exam Configuration Created Successfully.' );
                redirect('exam_configuration','refresh');
            } else {
                set_alert('error' , 'Error While Creating Exam Configuration.');
            }
        }
        $this->load->view('exam_configuration/create',$this->data);
    }
    
    public function edit(){
        $this->data['exam_configuration'] = $this->ec_model->get($this->input->post('edit_id'));
        $this->load->view('exam_configuration/edit',$this->data);
    }
    
    public function update(){       
        //  print_r($this->input->post()); die();
       if($this->ec_model->update()){
           set_alert('success' ,'Exam Configuration Updated Successfully.' );
           redirect('exam_configuration','refresh');
       } else {
           set_alert('error' , 'Error While Updating Exam Configuration.');
       }      
  }
  
   public function delete(){
       
        if( $this->ec_model->delete($this->input->post('delete_id')) ){
            set_alert('success','Exam ec_model deleted successfully.');
        } else {
            set_alert('error','Error while deleting Exam ec_model.');
        }             
        redirect('exam_ec_model');
    }
    
    /* Selected Items of exam org and post level */    
    public function selectExamOrg( $examStandardID = NULL ){
        echo json_encode($this->ec_model->selectedExamOrg($examStandardID));
        exit();
    }
    
    public function selectPostLevel( $examOrgID = NULL ){
        echo json_encode($this->ec_model->selectedPostLevel($examOrgID));
        exit();
    }

    public function add_subject()
    {

        if($_POST){

            $this->form_validation->set_rules(array(
                array(
                    'field' => 'subject',
                    'label' => 'Subject',
                    'rules' => 'required',
                    'errors' => array(
                            'required' => 'Please select a %s to add to the Exam.'
                            )
                ),
                array(
                    'field' => 'nos_ques',
                    'label' => 'No. of Questions',
                    'rules' => 'required|numeric',
                    'errors' => array(
                            'required'  => 'Please enter the %s to be added from this Subject to the Exam.',
                            'numeric'   => 'The value for this field must me numeric.',
                            )
                ),
            ));

            $form_validation = $this->form_validation->run();
            if( $form_validation == TRUE ) {
                
                $this->form_validation->reset_validation();
                
                $data = array(
                    'subject' => $this->subject_model->get($this->input->post('subject')),
                    'nos_ques' => $this->input->post('nos_ques')
                );

                $_POST['subject'] = NULL;
                $_POST['nos_ques'] = NULL;
                
                echo json_encode(array(
                    'html' => $this->load->view('exam_configuration/add_subject',$this->data,TRUE),
                    'form_validation' => $form_validation,
                    'subject_list' => $this->load->view('exam_configuration/subject_list',$data,TRUE)
                ));
                exit();
            }
            
            echo json_encode(array(
                'html' => $this->load->view('exam_configuration/add_subject',$this->data,TRUE),
                'form_validation' => $form_validation
            ));
            exit();
        }

        echo $this->load->view('exam_configuration/add_subject',$this->data,TRUE);
        exit();
    }
  
}

